<?php
#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 27.10.2024

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName('Berichte');
requireLogin();
requireRole(['Auswerter', 'Bearbeiter', 'Administrator']);
showSessionAlert();

initializeDatabaseConnection();

include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Berichte</h4>
        <span class="text-secondary">Dashboard</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">
    </div>
</div>

<div class="row">

    <div class="col-lg-12 col-xl-4 grid-margin">
        <div class="card">
            <div class="card-header bg-danger text-white">
                Alarm
            </div>
            <div class="list-group list-group-flush">
                <a href="/reports/report-zones" class="list-group-item list-group-item-action">Zonenauswertung</a>
                <a href="/reports/report-shelters" class="list-group-item list-group-item-action">Schutzbauten</a>
            </div>
        </div>
    </div>

    <?php showIfRole(['Bearbeiter', 'Administrator'], '
        <div class="col-lg-12 col-xl-4 grid-margin">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    Militärische Sicherheit
                </div>
                <div class="list-group list-group-flush">
                    <a href="/reports/report-safetybriefings" class="list-group-item list-group-item-action">Sicherheitsbelehrungen</a>
                    <a href="/reports/report-bamad" class="list-group-item list-group-item-action">Militärische Abschirmdienst</a>
                    <a href="#" class="list-group-item list-group-item-action">Konflikte <span style="margin-left:15px;font-size:10px;" class="text-warning">NICHT VERFÜGBAR</span></a>
                </div>
            </div>
        </div>
        '); ?>

    <?php /** showIfRole(['Bearbeiter', 'Administrator'], '
<div class="col-lg-12 col-xl-4 grid-margin">
<div class="card">
<div class="card-header bg-primary text-white">
Personal
</div>
<div class="list-group list-group-flush">
<a href="#" class="list-group-item list-group-item-action">Dienstpostenübersicht <span style="margin-left:15px;font-size:10px;" class="text-warning">NICHT VERFÜGBAR</span></a>
<a href="#" class="list-group-item list-group-item-action">Dienstposten ohne Nachfolger <span style="margin-left:15px;font-size:10px;" class="text-warning">NICHT VERFÜGBAR</span></a>
<a href="#" class="list-group-item list-group-item-action">Personalübersicht <span style="margin-left:15px;font-size:10px;" class="text-warning">NICHT VERFÜGBAR</span></a>
</div>
</div>
</div>
'); */ ?>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>